<?php

function sm_accordion_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'accordion', $view_params );
}

function sm_register_shortcode_handler_sm_accordion() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-accordion.php' );
		class WPBakeryShortCode_sm_accordion extends WPBakeryShortCode_VC_Accordion {
			function content($atts, $content = null) {
				return sm_accordion_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_accordion', 'sm_accordion_func' );
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Accordion', 'semona-extension' ),
	'base' => 'sm_accordion',
	'show_settings_on_create' => false,
	'is_container' => true,
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Collapsible content panels', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-accordion.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'semona-extension' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'semona-extension' )
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Active section', 'semona-extension' ),
			'param_name' => 'active_tab',
			'description' => esc_html__( 'Enter section number to be active on load or enter "false" to collapse all sections.', 'semona-extension' )
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Allow collapse all sections?', 'semona-extension' ),
			'param_name' => 'collapsible',
			'description' => esc_html__( 'If checked, it is allowed to collapse all sections.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' )
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Disable keyboard interactions?', 'semona-extension' ),
			'param_name' => 'disable_keyboard',
			'description' => esc_html__( 'If checked, disables keyboard arrow interactions (Keys: Left, Up, Right, Down, Space).', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Shape', 'semona-extension' ),
			'param_name' => 'shape',
			'value' => sm_get_accordion_tab_shapes_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'description' => esc_html__( 'Select style.', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_accordion_styles_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Header Background Color', 'semona-extension' ),
			'param_name' => 'header_bg_color',
			'description' => esc_html__( 'Select background color of active panel header.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_bg_colors_array( true ),
			'std' => 'sm-bg-color2',
			'dependency' => array(
				'element' => 'style',
				'value' => array( 'sm-style-solid' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Header Background Color', 'semona-extension' ),
			'param_name' => 'header_custom_bg_color',
			'description' => esc_html__( 'Select custom background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'header_bg_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Header Text Color', 'semona-extension' ),
			'param_name' => 'header_text_color',
			'description' => esc_html__( 'Select text color of panel header. Leave blank to use default.', 'semona-extension' ),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Active Header Background Color', 'semona-extension' ),
			'param_name' => 'active_header_bg_color',
			'description' => esc_html__( 'Select background color of active panel header.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_bg_colors_array( true ),
			'dependency' => array(
				'element' => 'style',
				'value' => array( 'sm-style-solid' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Active Header Background Color', 'semona-extension' ),
			'param_name' => 'active_header_custom_bg_color',
			'description' => esc_html__( 'Select custom background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'active_header_bg_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Active Header Text Color', 'semona-extension' ),
			'param_name' => 'active_header_text_color',
			'description' => esc_html__( 'Select text color of active panel header. Leave blank to use default.', 'semona-extension' ),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),

		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Header Has Border Box?', 'semona-extension' ),
			'param_name' => 'header_border',
			'description' => esc_html__( 'If checked, header has border box.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'dependency' => array(
				'element' => 'style',
				'value' => array( 'sm-style-solid', 'sm-style-def-grad1', 'sm-style-def-grad2' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Content Has Border Box?', 'semona-extension' ),
			'param_name' => 'content_border',
			'description' => esc_html__( 'If checked, content area has border box.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'dependency' => array(
				'element' => 'style',
				'value' => array( 'sm-style-solid', 'sm-style-def-grad1', 'sm-style-def-grad2' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Plus and Minus Controls Style', 'semona-extension' ),
			'param_name' => 'ctrl_style',
			'value' => sm_get_accordion_ctrl_styles_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Plus and Minus Controls Position', 'semona-extension' ),
			'param_name' => 'ctrl_align',
			'value' => sm_get_accordion_ctrl_aligns_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		sm_extra_class()
	),
	'custom_markup' => '
<div class="wpb_accordion_holder wpb_holder clearfix vc_container_for_children">
%content%
</div>
<div class="tab_controls">
    <a class="add_tab" title="' . esc_html__( 'Add section', 'semona-extension' ) . '"><span class="vc_icon"></span> <span class="tab-label">' . esc_html__( 'Add section', 'semona-extension' ) . '</span></a>
</div>
',
	'default_content' => '
    [sm_accordion_tab title="' . esc_html__( 'Section 1', 'semona-extension' ) . '"][/sm_accordion_tab]
    [sm_accordion_tab title="' . esc_html__( 'Section 2', 'semona-extension' ) . '"][/sm_accordion_tab]
',
	'js_view' => 'SMAccordionView'
) );